<?php
defined('BASEPATH') OR exit('This page does not exist');

class Checkout extends CI_Controller
{
    public function __construct()
    {
        parent:: __construct();
    }

    public function index()
    {
        $this->load->library(array('paypal_express' => 'paypal'));

        $paypal = $this->paypal;

        // $sandbox = $paypal->paypalClientID;
        // $env = $paypal->paypalEnv;
        // $production = $paypal->paypalClientID;

        $sandbox = $paypal->public_api_key();
        $env = $paypal->paypal_env();
        $production = $paypal->public_api_key();

        $this->smarty->view('payment/checkout.tpl', compact(
            'sandbox',
            'env',
            'production'
        ));
    }

    public function process()
    {
        if($_GET['pay_method'] == 'paypal')
        {
            $redirectStr = '';
            if(!empty($_GET['paymentID']) && !empty($_GET['token']) && !empty($_GET['payerID']) && !empty($_GET['itd']) ){
                

                // Include and initialize paypal class
                $this->load->library(array('paypal_express' => 'paypal'));
                $paypal = $this->paypal;
                
                // Get payment info from URL
                $paymentID = $_GET['paymentID'];
                $token = $_GET['token'];
                $payerID = $_GET['payerID'];
                $productID = $_GET['itd'];
                
                // Validate transaction via PayPal API
                $paymentCheck = $paypal->validate($paymentID, $token, $payerID, $productID);
                
                // If the payment is valid and approved
                if($paymentCheck && $paymentCheck->state == 'approved'){

                    // Get the transaction data
                    $id = $paymentCheck->id;
                    $state = $paymentCheck->state;
                    $payerFirstName = $paymentCheck->payer->payer_info->first_name;
                    $payerLastName = $paymentCheck->payer->payer_info->last_name;
                    $payerName = $payerFirstName.' '.$payerLastName;
                    $payerEmail = $paymentCheck->payer->payer_info->email;
                    $payerID = $paymentCheck->payer->payer_info->payer_id;
                    $payerCountryCode = $paymentCheck->payer->payer_info->country_code;
                    $paidAmount = $paymentCheck->transactions[0]->amount->details->subtotal;
                    $currency = $paymentCheck->transactions[0]->amount->currency;
                    
                    
                    //$productData = $db->getRows('products', $conditions);
                    $productData = $this->Item_model->getItemPaidFor($productID);

                    if($is_flash = $this->Item_model->checkIfItemIsFalsh($productID)) {
                        $item_price_get = $this->Item_model->getFlashItemPrice($productID);
                    } else {
                        $item_price_get = $productData->item_regu_price;
                    }
                    
                    // If payment price is valid
                    if($item_price_get >= $paidAmount){

                        //* Site make charges on item
                        $site_info = $this->Settings_model->getApllicationInfo();
                        $site_charge = $site_info->set_item_charge;

                        //* Let do charges Calculations
                        $item_price = $item_price_get;

                        $cal = ($site_charge / 100) * $item_price;

                        $earn = number_format($item_price - $cal, 2); //* What the author will earn

                        //* Let creadit the author balance
                        $author_id = $productData->item_user_id;

                        //* Catch the author current balance
                        $author_info = $this->Account_model->catchAuthorInfoInPayment($author_id);

                        $a_current_bal = $author_info->bal_value; //* Get the authour current balance

                        // * The to auhor balance
                        $new_a_balance = number_format($a_current_bal + $earn, 2);

                        //* Update the author account
                        $this->Account_model->updateAuthorAccountBalance($author_id, $new_a_balance);

                        //* Let check if purchase are made via refers
                        $site_info = $this->Settings_model->getApllicationInfo();
                        $ref_stat = $site_info->set_affi_status;
                        $ref_rate = $site_info->set_affi_rate;

                        if ($ref_stat == 1) {

                            if ($this->session->userdata('ref')) {
                                //* Let do benefit charges
                                $ref = $this->session->userdata('ref');

                                $ref_cal = ($ref_rate / 100) * $cal;

                                $ref_earn = number_format($ref_cal, 2); //* What the benefical will earn

                                //* Let check if refer exist in our database
                                if ($ref_id = $this->Account_model->checkIfRefExist($ref)) {
                                    //* Let credit his balance
                                    $ref_info = $this->Account_model->catchAuthorInfoInPayment($ref_id);

                                    $a_current_bal = $ref_info->bal_value; //* Get the authour current balance

                                    // * The to auhor balance
                                    $new_a_balance = number_format($a_current_bal + $ref_earn, 2);

                                    //* Update the author account
                                    $this->Account_model->updateAuthorAccountBalance($ref_id, $new_a_balance);
                                }
                            }
                        }

                        
                        // Insert transaction data in the database
                        $data = array(
                            'pp_product_id' => $productID,
                            'pp_txn_id' => $id,
                            'pp_payment_gross' => $paidAmount,
                            'pp_currency_code' => $currency,
                            'pp_payer_id' => $payerID,
                            'pp_payer_name' => $payerName,
                            'pp_payer_email' => $payerEmail,
                            'pp_payer_country' => $payerCountryCode,
                            'pp_payment_status' => $state,
                            'pp_user_id' => $this->session->userdata('uids')
                        );

                        $this->Payment_model->createPaypalTransaction($data);
                        
                        // Add insert id to the URL
                        $redirectStr = '?id='.$productID;

                        //* Give item to user here
                        $uid = $this->session->userdata('uids');

                        if($dl_id = $this->Download_model->createNewDownload($uid, $productID))
                        {

                            //* Let update the author sell badge stat
                            $this->Account_model->updateAuthorSellBadgeStat($author_id, $productID, $item_price_get, $dl_id);

                            //* Let update sale statement

                            //* Generate purchase code
                            $n = 20;
                            $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'; 
                            $randomString = '';
                            for ($i = 0; $i < $n; $i++) { 
                                $index = rand(0, strlen($characters) - 1); 
                                $randomString .= $uid.$productID.$characters[$index]; 
                            }

                            //* Let send to data base
                            $this->Account_model->createNewSaleStatement($uid, $author_id, $earn, $productID, $randomString);

                            /*
                            ==============================================
                            * Let send transaction email to the user
                            ==============================================
                            */

                            //* Get the user informations
                            $u_info = $this->Account_model->getTheUserInfo($uid);

                            //* Let send transactional email to the user
                            $site_info = $this->Settings_model->getApllicationInfo();
                            $template = array(
                                'username' => $u_info->user_username,
                                'email' => $u_info->user_email,
                                'firstname' => $u_info->user_firstname,
                                'lastname' => $u_info->user_lastname,
                                'sitename' => $site_info->set_site_name,
                                'sitelogo' => base_url() . 'static/website/site-logo/' . $site_info->set_site_logo,
                                'main_url' => base_url(),
                                'item_name' => $productData->item_name,
                                'author_user' => $author_info->user_username
                            );
                            
                            $send_u_tnx_email = $this->Email_model->getEmailTempsToSend($id = 3);
                            $template['send_msg'] = $send_u_tnx_email;
                            $messages = $this->parser->parse('mails/welcome/send', $template, true);

                            $email_set = $this->Settings_model->getSmtpDetails();
                            if ($email_set->smtp_type == 'ssl') {
                                $config['protocol']  = 'smtp';
                                $config['smtp_host'] = $email_set->smtp_type . '://' . $email_set->smtp_host;
                                $config['smtp_port'] = $email_set->smtp_port;
                                $config['smtp_user'] = $email_set->smtp_username;
                                $config['smtp_pass'] = $email_set->smtp_password;
                                $config['mailtype']  = 'html';
                                $config['charset']   = 'utf-8';
                                $config['newline'] = '\n';
                            } else {
                                $config['protocol']  = 'smtp';
                                $config['smtp_host'] = $email_set->smtp_host;
                                $config['smtp_port'] = $email_set->smtp_port;
                                $config['smtp_user'] = $email_set->smtp_username;
                                $config['smtp_pass'] = $email_set->smtp_password;
                                $config['mailtype']  = 'html';
                                $config['charset']   = 'utf-8';
                                $config['newline'] = '\n';
                            }

                            $this->email->initialize($config);
                            $this->email->set_mailtype("html");
                            $this->email->set_newline("\r\n");
                            $this->email->from($email_set->smtp_default_email, $email_set->smtp_display_name);
                            $this->email->to($u_info->user_email);
                            $this->email->subject('New Transaction');
                            $this->email->message($messages);
                            $this->email->send();


                            //* Show success message
                            $this->session->set_flashdata('error', '<div class="alert alert-success" align="center">Success! Thank You For Your Purchase</div>');
                        }
                    }
                    else
                    {
                        $this->session->set_flashdata('error', '<div class="alert alert-warning" align="center">Sorry! Your purchase could not be complete due to fraud payment</div>');
                    }
                }
                else
                {
                    $this->session->set_flashdata('error', '<div class="alert alert-danger" align="center">Error! Your purchase is unsuccessful</div>');
                }
                
                // Redirect to payment status page
                redirect('my-download');;
            }else{
                // Redirect to the home page
                redirect('error_404');
            }
        }
    }

    //* Stripe payment processing
    public function stripe_process()
    {
        $stripe = $this->Payment_model->getStripeGateway();
        $secret_key = $stripe->sg_secret_key;

        $response = array();

        // Check whether stripe token is not empty
        if(!empty($_POST['stripeToken'])){
            
            // Get token, card and item info
            $token  = $_POST['stripeToken'];
            $email  = $_POST['stripeEmail'];
            $itemPrice = $_POST['itemPrice'];
            $currency = $_POST['currency'];
            $itemName = $_POST['itemName'];
            $item_id = $_POST['item_id'];
            
            // Include Stripe PHP library
            // require_once('stripe-php/init.php');
            
            // Set api key
            \Stripe\Stripe::setApiKey($secret_key);
            
            // Add customer to stripe
            $customer = \Stripe\Customer::create(array(
                'email' => $email,
                'source'  => $token
            ));
            
            // Charge a credit or a debit card
            $charge = \Stripe\Charge::create(array(
                'customer' => $customer->id,
                'amount'   => $itemPrice,
                'currency' => $currency,
                'description' => $itemName,
            ));
            
            // Retrieve charge details
            $chargeJson = $charge->jsonSerialize();

            // Check whether the charge is successful
            if($chargeJson['amount_refunded'] == 0 && empty($chargeJson['failure_code']) && $chargeJson['paid'] == 1 && $chargeJson['captured'] == 1){
                
                // Order details 
                $amount = $chargeJson['amount'];
                $currency = $chargeJson['currency'];
                $txnID = $chargeJson['balance_transaction'];
                $status = $chargeJson['status'];
                $orderID = $chargeJson['id'];
                $payerName = $chargeJson['source']['name'];
                
                //* Stroe transaction details
                $data = array(
                    'sp_amount' => $amount,
                    'sp_item_id' => $item_id,
                    'sp_user_id' => $this->session->userdata('uids'),
                    'sp_currency' => $currency,
                    'sp_txn_id' => $txnID,
                    'sp_status' => $status,
                    'sp_order_id' =>$orderID,
                    'sp_payer_name' => $payerName,
                    'sp_payer_email' => $email
                ); 

                if($last_id = $this->Payment_model->createNewStripeTransaction($data))
                {
                    if($last_id && $status == 'succeeded')
                    {
                        $productData = $this->Item_model->getItemPaidFor($item_id);

                        if($is_flash = $this->Item_model->checkIfItemIsFalsh($item_id)) {
                            $item_price_get = $this->Item_model->getFlashItemPrice($item_id);
                        } else {
                            $item_price_get = $productData->item_regu_price;
                        }

                         //* Site make charges on item
                         $site_info = $this->Settings_model->getApllicationInfo();
                         $site_charge = $site_info->set_item_charge;
 
                         //* Let do charges Calculations
                         $item_price = $item_price_get;
 
                         $cal = ($site_charge / 100) * $item_price;
 
                         $earn = number_format($item_price - $cal, 2); //* What the author will earn
 
                         //* Let creadit the author balance
                         $author_id = $productData->item_user_id;
 
                         //* Catch the author current balance
                         $author_info = $this->Account_model->catchAuthorInfoInPayment($author_id);
 
                         $a_current_bal = $author_info->bal_value; //* Get the authour current balance
 
                         // * Then add to auhor balance
                         $new_a_balance = number_format($a_current_bal + $earn, 2);
 
                         //* Update the author account
                         $this->Account_model->updateAuthorAccountBalance($author_id, $new_a_balance);


                        //* Let us give item to the user
                        if($dl_id = $this->Download_model->createNewDownload($this->session->userdata('uids'), $item_id))
                        {
                            //* Let update the author sell badge stat
                            $this->Account_model->updateAuthorSellBadgeStat($author_id, $item_id, $item_price_get, $dl_id);
                        }

                        $uid = $this->session->userdata('uids');
                        $productID = $item_id;

                        //* Let update sale statement

                        //* Generate purchase code
                        $n = 20;
                        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'; 
                        $randomString = '';
                        for ($i = 0; $i < $n; $i++) { 
                            $index = rand(0, strlen($characters) - 1); 
                            $randomString .= $uid.$productID.$characters[$index]; 
                        }

                        //* Let send to data base
                        $this->Account_model->createNewSaleStatement($uid, $author_id, $earn, $productID, $randomString);


                        //* Let check if purchase are made via refers
                        $site_info = $this->Settings_model->getApllicationInfo();
                        $ref_stat = $site_info->set_affi_status;
                        $ref_rate = $site_info->set_affi_rate;

                        if ($ref_stat == 1) {

                            if ($this->session->userdata('ref')) {
                                //* Let do benefit charges
                                $ref = $this->session->userdata('ref');

                                $ref_cal = ($ref_rate / 100) * $cal;

                                $ref_earn = number_format($ref_cal, 2); //* What the benefical will earn

                                //* Let check if refer exist in our database
                                if ($ref_id = $this->Account_model->checkIfRefExist($ref)) {
                                    //* Let credit his balance
                                    $ref_info = $this->Account_model->catchAuthorInfoInPayment($ref_id);

                                    $a_current_bal = $ref_info->bal_value; //* Get the authour current balance

                                    // * The to auhor balance
                                    $new_a_balance = number_format($a_current_bal + $ref_earn, 2);

                                    //* Update the author account
                                    $this->Account_model->updateAuthorAccountBalance($ref_id, $new_a_balance);
                                }
                            }
                        }

                        /*
                        ==============================================
                        * Let send transaction email to the user
                        ==============================================
                        */

                        //* Get the user informations
                        $u_info = $this->Account_model->getTheUserInfo($this->session->userdata('uids'));

                        //* Let send transactional email to the user
                        $site_info = $this->Settings_model->getApllicationInfo();
                        $template = array(
                            'username' => $u_info->user_username,
                            'email' => $u_info->user_email,
                            'firstname' => $u_info->user_firstname,
                            'lastname' => $u_info->user_lastname,
                            'sitename' => $site_info->set_site_name,
                            'sitelogo' => base_url() . 'static/website/site-logo/' . $site_info->set_site_logo,
                            'main_url' => base_url(),
                            'item_name' => $productData->item_name,
                            'author_user' => $author_info->user_username
                        );
                        
                        $send_u_tnx_email = $this->Email_model->getEmailTempsToSend($id = 3);
                        $template['send_msg'] = $send_u_tnx_email;
                        $messages = $this->parser->parse('mails/welcome/send', $template, true);

                        $email_set = $this->Settings_model->getSmtpDetails();
                        if ($email_set->smtp_type == 'ssl') {
                            $config['protocol']  = 'smtp';
                            $config['smtp_host'] = $email_set->smtp_type . '://' . $email_set->smtp_host;
                            $config['smtp_port'] = $email_set->smtp_port;
                            $config['smtp_user'] = $email_set->smtp_username;
                            $config['smtp_pass'] = $email_set->smtp_password;
                            $config['mailtype']  = 'html';
                            $config['charset']   = 'utf-8';
                            $config['newline'] = '\n';
                        } else {
                            $config['protocol']  = 'smtp';
                            $config['smtp_host'] = $email_set->smtp_host;
                            $config['smtp_port'] = $email_set->smtp_port;
                            $config['smtp_user'] = $email_set->smtp_username;
                            $config['smtp_pass'] = $email_set->smtp_password;
                            $config['mailtype']  = 'html';
                            $config['charset']   = 'utf-8';
                            $config['newline'] = '\n';
                        }

                        $this->email->initialize($config);
                        $this->email->set_mailtype("html");
                        $this->email->set_newline("\r\n");
                        $this->email->from($email_set->smtp_default_email, $email_set->smtp_display_name);
                        $this->email->to($u_info->user_email);
                        $this->email->subject('New Transaction');
                        $this->email->message($messages);
                        $this->email->send();

                        $response = array(
                            'status' => 1,
                            'msg' => 'Your payment was successful.',
                            'txnData' => $chargeJson
                        );
                    }
                    else
                    {
                        $response = array(
                            'status' => 0,
                            'msg' => 'Transaction has been failed.'
                        );
                    }
                }

            }else{
                $response = array(
                    'status' => 0,
                    'msg' => 'Transaction has been failed.'
                );
            }
        }else{
            $response = array(
                'status' => 0,
                'msg' => 'Form submission error...'
            );
        }

        // Return response
        echo json_encode($response);
    }

    //* Purchasing via creait balance
    public function buy_with_credit()
    {
        if(! $this->session->userdata('uids'))
        {
            redirect('error_404');
            exit();
        }

        if(isset($_POST['item_id']))
        {
            //* Let the user continue to checkout

            $item_id = $this->input->post('item_id');
            $uid = $this->session->userdata('uids');

            //* Let grab the item infomations
            $item_info = $this->Item_model->getItemPayViaBtcPrice($item_id);

            if($is_flash = $this->Item_model->checkIfItemIsFalsh($item_id)) {
                $item_price = $this->Item_model->getFlashItemPrice($item_id);
            } else {
                $item_price = $item_info->item_regu_price;
            }

            //* Let grab the user current balance
            $ubal = $this->Account_model->getTheAvaliableUserBalance($uid);
            $cbal = $this->Account_model->getUserAvailbaleCreditBal($uid);

            //* Let detect if Credit balance enough to buy
            if($cbal >= $item_price)
            {
                //* Continue purchasing
                $i_price = $item_price;
                $u_bal = $cbal;

                //* Let charge the user
                $left_bal = $u_bal - $i_price;

                $left_bal = number_format($left_bal, 2);

                //* Let update the user credit balance
                if($this->Account_model->updateUserAltCreditBal($uid, $left_bal))
                {
                    $productData = $this->Item_model->getItemPaidFor($item_id);

                    if($is_flash = $this->Item_model->checkIfItemIsFalsh($item_id)) {
                        $item_price = $this->Item_model->getFlashItemPrice($item_id);
                    } else {
                        //* Let do charges Calculations
                        $item_price = $productData->item_regu_price;
                    }

                    //* Site make charges on item
                    $site_info = $this->Settings_model->getApllicationInfo();
                    $site_charge = $site_info->set_item_charge;


                    $cal = ($site_charge / 100) * $item_price;

                    $earn = number_format($item_price - $cal, 2); //* What the author will earn

                    //* Let creadit the author balance
                    $author_id = $productData->item_user_id;

                    //* Catch the author current balance
                    $author_info = $this->Account_model->catchAuthorInfoInPayment($author_id);

                    $a_current_bal = $author_info->bal_value; //* Get the authour current balance

                    // * Then add to auhor balance
                    $new_a_balance = number_format($a_current_bal + $earn, 2);

                    //* Update the author account
                    $this->Account_model->updateAuthorAccountBalance($author_id, $new_a_balance);


                //* Let us give item to the user
                if($dl_id = $this->Download_model->createNewDownload($this->session->userdata('uids'), $item_id))
                {
                    $this->Account_model->updateAuthorSellBadgeStat($author_id, $item_id, $item_price, $dl_id);
                }

                $uid = $this->session->userdata('uids');
                $productID = $item_id;

                //* Let update sale statement

                //* Generate purchase code
                $n = 20;
                $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'; 
                $randomString = '';
                for ($i = 0; $i < $n; $i++) { 
                    $index = rand(0, strlen($characters) - 1); 
                    $randomString .= $uid.$productID.$characters[$index]; 
                }

                //* Let send to data base
                $this->Account_model->createNewSaleStatement($uid, $author_id, $earn, $productID, $randomString);

                //* Let check if purchase are made via refers
                $site_info = $this->Settings_model->getApllicationInfo();
                $ref_stat = $site_info->set_affi_status;
                $ref_rate = $site_info->set_affi_rate;

                if ($ref_stat == 1) {

                    if ($this->session->userdata('ref')) {
                        //* Let do benefit charges
                        $ref = $this->session->userdata('ref');

                        $ref_cal = ($ref_rate / 100) * $cal;

                        $ref_earn = number_format($ref_cal, 2); //* What the benefical will earn

                        //* Let check if refer exist in our database
                        if ($ref_id = $this->Account_model->checkIfRefExist($ref)) {
                            //* Let credit his balance
                            $ref_info = $this->Account_model->catchAuthorInfoInPayment($ref_id);

                            $a_current_bal = $ref_info->bal_value; //* Get the authour current balance

                            // * The to auhor balance
                            $new_a_balance = number_format($a_current_bal + $ref_earn, 2);

                            //* Update the author account
                            $this->Account_model->updateAuthorAccountBalance($ref_id, $new_a_balance);
                        }
                    }
                }

                /*
                ==============================================
                * Let send transaction email to the user
                ==============================================
                */

                //* Get the user informations
                $u_info = $this->Account_model->getTheUserInfo($this->session->userdata('uids'));

                //* Let send transactional email to the user
                $site_info = $this->Settings_model->getApllicationInfo();
                $template = array(
                    'username' => $u_info->user_username,
                    'email' => $u_info->user_email,
                    'firstname' => $u_info->user_firstname,
                    'lastname' => $u_info->user_lastname,
                    'sitename' => $site_info->set_site_name,
                    'sitelogo' => base_url() . 'static/website/site-logo/' . $site_info->set_site_logo,
                    'main_url' => base_url(),
                    'item_name' => $productData->item_name,
                    'author_user' => $author_info->user_username
                );
                
                $send_u_tnx_email = $this->Email_model->getEmailTempsToSend($id = 3);
                $template['send_msg'] = $send_u_tnx_email;
                $messages = $this->parser->parse('mails/welcome/send', $template, true);

                $email_set = $this->Settings_model->getSmtpDetails();
                if ($email_set->smtp_type == 'ssl') {
                    $config['protocol']  = 'smtp';
                    $config['smtp_host'] = $email_set->smtp_type . '://' . $email_set->smtp_host;
                    $config['smtp_port'] = $email_set->smtp_port;
                    $config['smtp_user'] = $email_set->smtp_username;
                    $config['smtp_pass'] = $email_set->smtp_password;
                    $config['mailtype']  = 'html';
                    $config['charset']   = 'utf-8';
                    $config['newline'] = '\n';
                } else {
                    $config['protocol']  = 'smtp';
                    $config['smtp_host'] = $email_set->smtp_host;
                    $config['smtp_port'] = $email_set->smtp_port;
                    $config['smtp_user'] = $email_set->smtp_username;
                    $config['smtp_pass'] = $email_set->smtp_password;
                    $config['mailtype']  = 'html';
                    $config['charset']   = 'utf-8';
                    $config['newline'] = '\n';
                }

                $this->email->initialize($config);
                $this->email->set_mailtype("html");
                $this->email->set_newline("\r\n");
                $this->email->from($email_set->smtp_default_email, $email_set->smtp_display_name);
                $this->email->to($u_info->user_email);
                $this->email->subject('New Transaction');
                $this->email->message($messages);
                $this->email->send();
                
                $this->session->set_flashdata('error', '<div class="alert alert-success" align="center">Thank you for your purchase</div>');
                redirect('my-download');
                
                }
            }
            elseif($ubal >= $item_price)
            {
                //* Continue purchasing
                $i_price = $item_price;
                $u_bal = $ubal;

                //* Let charge the user
                $left_bal = $u_bal - $i_price;

                $left_bal = number_format($left_bal, 2);

                //* Let update the user credit balance
                if($this->Account_model->updateUserCreditBal($uid, $left_bal))
                {
                    $productData = $this->Item_model->getItemPaidFor($item_id);

                    if($is_flash = $this->Item_model->checkIfItemIsFalsh($item_id)) {
                        $item_price = $this->Item_model->getFlashItemPrice($item_id);
                    } else {
                        //* Let do charges Calculations
                        $item_price = $productData->item_regu_price;
                    }

                    //* Site make charges on item
                    $site_info = $this->Settings_model->getApllicationInfo();
                    $site_charge = $site_info->set_item_charge;


                    $cal = ($site_charge / 100) * $item_price;

                    $earn = number_format($item_price - $cal, 2); //* What the author will earn

                    //* Let creadit the author balance
                    $author_id = $productData->item_user_id;

                    //* Catch the author current balance
                    $author_info = $this->Account_model->catchAuthorInfoInPayment($author_id);

                    $a_current_bal = $author_info->bal_value; //* Get the authour current balance

                    // * Then add to auhor balance
                    $new_a_balance = number_format($a_current_bal + $earn, 2);

                    //* Update the author account
                    $this->Account_model->updateAuthorAccountBalance($author_id, $new_a_balance);


                //* Let us give item to the user
                if($dl_id = $this->Download_model->createNewDownload($this->session->userdata('uids'), $item_id))
                {
                    $this->Account_model->updateAuthorSellBadgeStat($author_id, $item_id, $item_price, $dl_id);
                }

                $uid = $this->session->userdata('uids');
                $productID = $item_id;

                //* Let update sale statement

                //* Generate purchase code
                $n = 20;
                $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'; 
                $randomString = '';
                for ($i = 0; $i < $n; $i++) { 
                    $index = rand(0, strlen($characters) - 1); 
                    $randomString .= $uid.$productID.$characters[$index]; 
                }

                //* Let send to data base
                $this->Account_model->createNewSaleStatement($uid, $author_id, $earn, $productID, $randomString);

                //* Let check if purchase are made via refers
                $site_info = $this->Settings_model->getApllicationInfo();
                $ref_stat = $site_info->set_affi_status;
                $ref_rate = $site_info->set_affi_rate;

                if ($ref_stat == 1) {

                    if ($this->session->userdata('ref')) {
                        //* Let do benefit charges
                        $ref = $this->session->userdata('ref');

                        $ref_cal = ($ref_rate / 100) * $cal;

                        $ref_earn = number_format($ref_cal, 2); //* What the benefical will earn

                        //* Let check if refer exist in our database
                        if ($ref_id = $this->Account_model->checkIfRefExist($ref)) {
                            //* Let credit his balance
                            $ref_info = $this->Account_model->catchAuthorInfoInPayment($ref_id);

                            $a_current_bal = $ref_info->bal_value; //* Get the authour current balance

                            // * The to auhor balance
                            $new_a_balance = number_format($a_current_bal + $ref_earn, 2);

                            //* Update the author account
                            $this->Account_model->updateAuthorAccountBalance($ref_id, $new_a_balance);
                        }
                    }
                }

                /*
                ==============================================
                * Let send transaction email to the user
                ==============================================
                */

                //* Get the user informations
                $u_info = $this->Account_model->getTheUserInfo($this->session->userdata('uids'));

                //* Let send transactional email to the user
                $site_info = $this->Settings_model->getApllicationInfo();
                $template = array(
                    'username' => $u_info->user_username,
                    'email' => $u_info->user_email,
                    'firstname' => $u_info->user_firstname,
                    'lastname' => $u_info->user_lastname,
                    'sitename' => $site_info->set_site_name,
                    'sitelogo' => base_url() . 'static/website/site-logo/' . $site_info->set_site_logo,
                    'main_url' => base_url(),
                    'item_name' => $productData->item_name,
                    'author_user' => $author_info->user_username
                );
                
                $send_u_tnx_email = $this->Email_model->getEmailTempsToSend($id = 3);
                $template['send_msg'] = $send_u_tnx_email;
                $messages = $this->parser->parse('mails/welcome/send', $template, true);

                $email_set = $this->Settings_model->getSmtpDetails();
                if ($email_set->smtp_type == 'ssl') {
                    $config['protocol']  = 'smtp';
                    $config['smtp_host'] = $email_set->smtp_type . '://' . $email_set->smtp_host;
                    $config['smtp_port'] = $email_set->smtp_port;
                    $config['smtp_user'] = $email_set->smtp_username;
                    $config['smtp_pass'] = $email_set->smtp_password;
                    $config['mailtype']  = 'html';
                    $config['charset']   = 'utf-8';
                    $config['newline'] = '\n';
                } else {
                    $config['protocol']  = 'smtp';
                    $config['smtp_host'] = $email_set->smtp_host;
                    $config['smtp_port'] = $email_set->smtp_port;
                    $config['smtp_user'] = $email_set->smtp_username;
                    $config['smtp_pass'] = $email_set->smtp_password;
                    $config['mailtype']  = 'html';
                    $config['charset']   = 'utf-8';
                    $config['newline'] = '\n';
                }

                $this->email->initialize($config);
                $this->email->set_mailtype("html");
                $this->email->set_newline("\r\n");
                $this->email->from($email_set->smtp_default_email, $email_set->smtp_display_name);
                $this->email->to($u_info->user_email);
                $this->email->subject('New Transaction');
                $this->email->message($messages);
                $this->email->send();
                
                $this->session->set_flashdata('error', '<div class="alert alert-success" align="center">Thank you for your purchase</div>');
                redirect('my-download');
                
                }
            }
            elseif($ubal > 1 && $cbal > 1)
            {
                //* Let detect if both balace can be both used

                //* Continue purchasing
                $i_price = $item_price;
                $u_bal = $ubal;
                $c_bal = $cbal;

                //* Get left over after charging alt credit
                $left_over = $i_price - $cbal; //* Get left over balace to charge

                //* Let detect if left user balace can make the purchase
                if($ubal >= $left_over)
                {
                    //* Let update user credit to zero
                    if($this->Account_model->updateUserAltCreditBal($uid, 0))
                    {
                        //* Let charge the user
                        $left_bal = $u_bal - $left_over;

                        $left_bal = number_format($left_bal, 2);

                        //* Let update the user credit balance
                        if($this->Account_model->updateUserCreditBal($uid, $left_bal))
                        {
                            $productData = $this->Item_model->getItemPaidFor($item_id);

                            if($is_flash = $this->Item_model->checkIfItemIsFalsh($item_id)) {
                                $item_price = $this->Item_model->getFlashItemPrice($item_id);
                            } else {
                                //* Let do charges Calculations
                                $item_price = $productData->item_regu_price;
                            }

                            //* Site make charges on item
                            $site_info = $this->Settings_model->getApllicationInfo();
                            $site_charge = $site_info->set_item_charge;


                            $cal = ($site_charge / 100) * $item_price;

                            $earn = number_format($item_price - $cal, 2); //* What the author will earn

                            //* Let creadit the author balance
                            $author_id = $productData->item_user_id;

                            //* Catch the author current balance
                            $author_info = $this->Account_model->catchAuthorInfoInPayment($author_id);

                            $a_current_bal = $author_info->bal_value; //* Get the authour current balance

                            // * Then add to auhor balance
                            $new_a_balance = number_format($a_current_bal + $earn, 2);

                            //* Update the author account
                            $this->Account_model->updateAuthorAccountBalance($author_id, $new_a_balance);


                        //* Let us give item to the user
                        if($dl_id = $this->Download_model->createNewDownload($this->session->userdata('uids'), $item_id))
                        {
                            $this->Account_model->updateAuthorSellBadgeStat($author_id, $item_id, $item_price, $dl_id);
                        }

                        $uid = $this->session->userdata('uids');
                        $productID = $item_id;

                        //* Let update sale statement

                        //* Generate purchase code
                        $n = 20;
                        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'; 
                        $randomString = '';
                        for ($i = 0; $i < $n; $i++) { 
                            $index = rand(0, strlen($characters) - 1); 
                            $randomString .= $uid.$productID.$characters[$index]; 
                        }

                        //* Let send to data base
                        $this->Account_model->createNewSaleStatement($uid, $author_id, $earn, $productID, $randomString);

                        //* Let check if purchase are made via refers
                        $site_info = $this->Settings_model->getApllicationInfo();
                        $ref_stat = $site_info->set_affi_status;
                        $ref_rate = $site_info->set_affi_rate;

                        if ($ref_stat == 1) {

                            if ($this->session->userdata('ref')) {
                                //* Let do benefit charges
                                $ref = $this->session->userdata('ref');

                                $ref_cal = ($ref_rate / 100) * $cal;

                                $ref_earn = number_format($ref_cal, 2); //* What the benefical will earn

                                //* Let check if refer exist in our database
                                if ($ref_id = $this->Account_model->checkIfRefExist($ref)) {
                                    //* Let credit his balance
                                    $ref_info = $this->Account_model->catchAuthorInfoInPayment($ref_id);

                                    $a_current_bal = $ref_info->bal_value; //* Get the authour current balance

                                    // * The to auhor balance
                                    $new_a_balance = number_format($a_current_bal + $ref_earn, 2);

                                    //* Update the author account
                                    $this->Account_model->updateAuthorAccountBalance($ref_id, $new_a_balance);
                                }
                            }
                        }

                        /*
                        ==============================================
                        * Let send transaction email to the user
                        ==============================================
                        */

                        //* Get the user informations
                        $u_info = $this->Account_model->getTheUserInfo($this->session->userdata('uids'));

                        //* Let send transactional email to the user
                        $site_info = $this->Settings_model->getApllicationInfo();
                        $template = array(
                            'username' => $u_info->user_username,
                            'email' => $u_info->user_email,
                            'firstname' => $u_info->user_firstname,
                            'lastname' => $u_info->user_lastname,
                            'sitename' => $site_info->set_site_name,
                            'sitelogo' => base_url() . 'static/website/site-logo/' . $site_info->set_site_logo,
                            'main_url' => base_url(),
                            'item_name' => $productData->item_name,
                            'author_user' => $author_info->user_username
                        );
                        
                        $send_u_tnx_email = $this->Email_model->getEmailTempsToSend($id = 3);
                        $template['send_msg'] = $send_u_tnx_email;
                        $messages = $this->parser->parse('mails/welcome/send', $template, true);

                        $email_set = $this->Settings_model->getSmtpDetails();
                        if ($email_set->smtp_type == 'ssl') {
                            $config['protocol']  = 'smtp';
                            $config['smtp_host'] = $email_set->smtp_type . '://' . $email_set->smtp_host;
                            $config['smtp_port'] = $email_set->smtp_port;
                            $config['smtp_user'] = $email_set->smtp_username;
                            $config['smtp_pass'] = $email_set->smtp_password;
                            $config['mailtype']  = 'html';
                            $config['charset']   = 'utf-8';
                            $config['newline'] = '\n';
                        } else {
                            $config['protocol']  = 'smtp';
                            $config['smtp_host'] = $email_set->smtp_host;
                            $config['smtp_port'] = $email_set->smtp_port;
                            $config['smtp_user'] = $email_set->smtp_username;
                            $config['smtp_pass'] = $email_set->smtp_password;
                            $config['mailtype']  = 'html';
                            $config['charset']   = 'utf-8';
                            $config['newline'] = '\n';
                        }

                        $this->email->initialize($config);
                        $this->email->set_mailtype("html");
                        $this->email->set_newline("\r\n");
                        $this->email->from($email_set->smtp_default_email, $email_set->smtp_display_name);
                        $this->email->to($u_info->user_email);
                        $this->email->subject('New Transaction');
                        $this->email->message($messages);
                        $this->email->send();
                        
                        $this->session->set_flashdata('error', '<div class="alert alert-success" align="center">Thank you for your purchase</div>');
                        redirect('my-download');
                        
                        }
                    }
                }
                else
                {
                    echo "<script> alert('You do not have enough credit to complete purchase');</script>";
                    echo "<script>window.history.back();</script>";
                }

            }
            else
            {
                echo "<script> alert('You do not have enough credit to complete purchase');</script>";
                echo "<script>window.history.back();</script>";
            }
        }
        else
        {
            redirect('error_404');
            exit();
        }
    }

    //* process paypal credit purchase
    public function process_credit_purchase()
    {
        if($_GET['pay_method'] == 'paypal')
        {
            $redirectStr = '';
            if(!empty($_GET['paymentID']) && !empty($_GET['token']) && !empty($_GET['payerID']) && !empty($_GET['itd']) ){
                

                // Include and initialize paypal class
                $this->load->library(array('paypal_express' => 'paypal'));
                $paypal = $this->paypal;
                
                // Get payment info from URL
                $paymentID = $_GET['paymentID'];
                $token = $_GET['token'];
                $payerID = $_GET['payerID'];
                $productID = $_GET['itd'];
                
                // Validate transaction via PayPal API
                $paymentCheck = $paypal->validate($paymentID, $token, $payerID, $productID);
                
                // If the payment is valid and approved
                if($paymentCheck && $paymentCheck->state == 'approved'){

                    // Get the transaction data
                    $id = $paymentCheck->id;
                    $state = $paymentCheck->state;
                    $payerFirstName = $paymentCheck->payer->payer_info->first_name;
                    $payerLastName = $paymentCheck->payer->payer_info->last_name;
                    $payerName = $payerFirstName.' '.$payerLastName;
                    $payerEmail = $paymentCheck->payer->payer_info->email;
                    $payerID = $paymentCheck->payer->payer_info->payer_id;
                    $payerCountryCode = $paymentCheck->payer->payer_info->country_code;
                    $paidAmount = $paymentCheck->transactions[0]->amount->details->subtotal;
                    $currency = $paymentCheck->transactions[0]->amount->currency;
                    
                    
                    //$productData = $db->getRows('products', $conditions);
                    $productData = $this->Extra_model->getCreditPurchashing($productID);

                    $item_price_get = $productData->pack_price;
                    
                    // If payment price is valid
                    if($item_price_get >= $paidAmount){
                        
                        // Add insert id to the URL
                        $redirectStr = '?id='.$productID;

                        //* Give item to user here
                        $uid = $this->session->userdata('uids');

                        //* let grap the user avaliable credit bal
                        $my_bal = $this->Account_model->getUserAvailbaleCreditBal($uid);

                        //* Generate new user balance
                        $new_bal = $productData->pack_price + $my_bal;
                        $new_bal = number_format($new_bal, 2);

                        //* Let credit the user balance
                        if($this->Account_model->addToUserCreditBal($uid, $new_bal))
                        {
                            //* Show success message
                            $this->session->set_flashdata('error', '<div class="alert alert-success" align="center">Credit has been purchase Successfully</div>');
                            redirect('buy-credit');
                            exit();
                        }
                    }
                    else
                    {
                        $this->session->set_flashdata('error', '<div class="alert alert-warning" align="center">Sorry! Your purchase could not be complete due to fraud payment</div>');
                        redirect('buy-credit');
                        exit();
                    }
                }
                else
                {
                    $this->session->set_flashdata('error', '<div class="alert alert-danger" align="center">Error! Your purchase is unsuccessful</div>');
                    redirect('buy-credit');
                    exit();
                }
                
                // Redirect to payment status page
                redirect('buy-credit');
                exit();
            }else{
                // Redirect to the home page
                redirect('error_404');
            }
        }
    }

    //* Process stripe credit purchase
    public function stripe_process_purchase_credit()
    {
        $stripe = $this->Payment_model->getStripeGateway();
        $secret_key = $stripe->sg_secret_key;

        $response = array();

        // Check whether stripe token is not empty
        if(!empty($_POST['stripeToken'])){
            
            // Get token, card and item info
            $token  = $_POST['stripeToken'];
            $email  = $_POST['stripeEmail'];
            $itemPrice = $_POST['itemPrice'];
            $currency = $_POST['currency'];
            $itemName = $_POST['itemName'];
            $item_id = $_POST['item_id'];
            
            // Include Stripe PHP library
            // require_once('stripe-php/init.php');
            
            // Set api key
            \Stripe\Stripe::setApiKey($secret_key);
            
            // Add customer to stripe
            $customer = \Stripe\Customer::create(array(
                'email' => $email,
                'source'  => $token
            ));
            
            // Charge a credit or a debit card
            $charge = \Stripe\Charge::create(array(
                'customer' => $customer->id,
                'amount'   => $itemPrice,
                'currency' => $currency,
                'description' => $itemName,
            ));
            
            // Retrieve charge details
            $chargeJson = $charge->jsonSerialize();

            // Check whether the charge is successful
            if($chargeJson['amount_refunded'] == 0 && empty($chargeJson['failure_code']) && $chargeJson['paid'] == 1 && $chargeJson['captured'] == 1){
                
                // Order details 
                $amount = $chargeJson['amount'];
                $currency = $chargeJson['currency'];
                $txnID = $chargeJson['balance_transaction'];
                $status = $chargeJson['status'];
                $orderID = $chargeJson['id'];
                $payerName = $chargeJson['source']['name'];

                if($status == 'succeeded')
                {
                    $productData = $this->Extra_model->getCreditPurchashing($item_id);

                    $item_price_get = $productData->pack_price;

                    //* Give item to user here
                    $uid = $this->session->userdata('uids');

                    //* let grap the user avaliable credit bal
                    $my_bal = $this->Account_model->getUserAvailbaleCreditBal($uid);

                    //* Generate new user balance
                    $new_bal = $productData->pack_price + $my_bal;
                    $new_bal = number_format($new_bal, 2);

                    //* Let credit the user balance
                    if($this->Account_model->addToUserCreditBal($uid, $new_bal))
                    {
                        $response = array(
                            'status' => 1,
                            'msg' => 'Your payment was successful.',
                            'txnData' => $chargeJson
                        );
                    }
                }
                else
                {
                     $response = array(
                    'status' => 0,
                    'msg' => 'Transaction has been failed.'
                );
                }

            }else{
                $response = array(
                    'status' => 0,
                    'msg' => 'Transaction has been failed.'
                );
            }
        }else{
            $response = array(
                'status' => 0,
                'msg' => 'Form submission error...'
            );
        }

        // Return response
        echo json_encode($response);
    }

    //* Paypal process extended liecense
    public function process_extended()
    {
        if($_GET['pay_method'] == 'paypal')
        {
            $redirectStr = '';
            if(!empty($_GET['paymentID']) && !empty($_GET['token']) && !empty($_GET['payerID']) && !empty($_GET['itd']) ){
                

                // Include and initialize paypal class
                $this->load->library(array('paypal_express' => 'paypal'));
                $paypal = $this->paypal;
                
                // Get payment info from URL
                $paymentID = $_GET['paymentID'];
                $token = $_GET['token'];
                $payerID = $_GET['payerID'];
                $productID = $_GET['itd'];
                
                // Validate transaction via PayPal API
                $paymentCheck = $paypal->validate($paymentID, $token, $payerID, $productID);
                
                // If the payment is valid and approved
                if($paymentCheck && $paymentCheck->state == 'approved'){

                    // Get the transaction data
                    $id = $paymentCheck->id;
                    $state = $paymentCheck->state;
                    $payerFirstName = $paymentCheck->payer->payer_info->first_name;
                    $payerLastName = $paymentCheck->payer->payer_info->last_name;
                    $payerName = $payerFirstName.' '.$payerLastName;
                    $payerEmail = $paymentCheck->payer->payer_info->email;
                    $payerID = $paymentCheck->payer->payer_info->payer_id;
                    $payerCountryCode = $paymentCheck->payer->payer_info->country_code;
                    $paidAmount = $paymentCheck->transactions[0]->amount->details->subtotal;
                    $currency = $paymentCheck->transactions[0]->amount->currency;
                    
                    
                    //$productData = $db->getRows('products', $conditions);
                    $productData = $this->Item_model->getItemPaidFor($productID);

                    if($is_flash = $this->Item_model->checkIfItemIsFalsh($productID)) {
                        $item_price_get = $productData->item_exte_price;
                    } else {
                        $item_price_get = $productData->item_exte_price;
                    }
                    
                    // If payment price is valid
                    if($item_price_get >= $paidAmount){

                        //* Site make charges on item
                        $site_info = $this->Settings_model->getApllicationInfo();
                        $site_charge = $site_info->set_item_charge;

                        //* Let do charges Calculations
                        $item_price = $item_price_get;

                        $cal = ($site_charge / 100) * $item_price;

                        $earn = number_format($item_price - $cal, 2); //* What the author will earn

                        //* Let creadit the author balance
                        $author_id = $productData->item_user_id;

                        //* Catch the author current balance
                        $author_info = $this->Account_model->catchAuthorInfoInPayment($author_id);

                        $a_current_bal = $author_info->bal_value; //* Get the authour current balance

                        // * The to auhor balance
                        $new_a_balance = number_format($a_current_bal + $earn, 2);

                        //* Update the author account
                        $this->Account_model->updateAuthorAccountBalance($author_id, $new_a_balance);

                        //* Let check if purchase are made via refers
                        $site_info = $this->Settings_model->getApllicationInfo();
                        $ref_stat = $site_info->set_affi_status;
                        $ref_rate = $site_info->set_affi_rate;

                        if ($ref_stat == 1) {

                            if ($this->session->userdata('ref')) {
                                //* Let do benefit charges
                                $ref = $this->session->userdata('ref');

                                $ref_cal = ($ref_rate / 100) * $cal;

                                $ref_earn = number_format($ref_cal, 2); //* What the benefical will earn

                                //* Let check if refer exist in our database
                                if ($ref_id = $this->Account_model->checkIfRefExist($ref)) {
                                    //* Let credit his balance
                                    $ref_info = $this->Account_model->catchAuthorInfoInPayment($ref_id);

                                    $a_current_bal = $ref_info->bal_value; //* Get the authour current balance

                                    // * The to auhor balance
                                    $new_a_balance = number_format($a_current_bal + $ref_earn, 2);

                                    //* Update the author account
                                    $this->Account_model->updateAuthorAccountBalance($ref_id, $new_a_balance);
                                }
                            }
                        }

                        
                        // Insert transaction data in the database
                        $data = array(
                            'pp_product_id' => $productID,
                            'pp_txn_id' => $id,
                            'pp_payment_gross' => $paidAmount,
                            'pp_currency_code' => $currency,
                            'pp_payer_id' => $payerID,
                            'pp_payer_name' => $payerName,
                            'pp_payer_email' => $payerEmail,
                            'pp_payer_country' => $payerCountryCode,
                            'pp_payment_status' => $state,
                            'pp_user_id' => $this->session->userdata('uids')
                        );

                        $this->Payment_model->createPaypalTransaction($data);
                        
                        // Add insert id to the URL
                        $redirectStr = '?id='.$productID;

                        //* Give item to user here
                        $uid = $this->session->userdata('uids');

                        if($dl_id = $this->Download_model->createNewDownload($uid, $productID, 1))
                        {

                            //* Let update the author sell badge stat
                            $this->Account_model->updateAuthorSellBadgeStat($author_id, $productID, $item_price_get, $dl_id);

                            //* Let update sale statement

                            //* Generate purchase code
                            $n = 20;
                            $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'; 
                            $randomString = '';
                            for ($i = 0; $i < $n; $i++) { 
                                $index = rand(0, strlen($characters) - 1); 
                                $randomString .= $uid.$productID.$characters[$index]; 
                            }

                            //* Let send to data base
                            $this->Account_model->createNewSaleStatement($uid, $author_id, $earn, $productID, $randomString);

                            /*
                            ==============================================
                            * Let send transaction email to the user
                            ==============================================
                            */

                            //* Get the user informations
                            $u_info = $this->Account_model->getTheUserInfo($uid);

                            //* Let send transactional email to the user
                            $site_info = $this->Settings_model->getApllicationInfo();
                            $template = array(
                                'username' => $u_info->user_username,
                                'email' => $u_info->user_email,
                                'firstname' => $u_info->user_firstname,
                                'lastname' => $u_info->user_lastname,
                                'sitename' => $site_info->set_site_name,
                                'sitelogo' => base_url() . 'static/website/site-logo/' . $site_info->set_site_logo,
                                'main_url' => base_url(),
                                'item_name' => $productData->item_name,
                                'author_user' => $author_info->user_username
                            );
                            
                            $send_u_tnx_email = $this->Email_model->getEmailTempsToSend($id = 3);
                            $template['send_msg'] = $send_u_tnx_email;
                            $messages = $this->parser->parse('mails/welcome/send', $template, true);

                            $email_set = $this->Settings_model->getSmtpDetails();
                            if ($email_set->smtp_type == 'ssl') {
                                $config['protocol']  = 'smtp';
                                $config['smtp_host'] = $email_set->smtp_type . '://' . $email_set->smtp_host;
                                $config['smtp_port'] = $email_set->smtp_port;
                                $config['smtp_user'] = $email_set->smtp_username;
                                $config['smtp_pass'] = $email_set->smtp_password;
                                $config['mailtype']  = 'html';
                                $config['charset']   = 'utf-8';
                                $config['newline'] = '\n';
                            } else {
                                $config['protocol']  = 'smtp';
                                $config['smtp_host'] = $email_set->smtp_host;
                                $config['smtp_port'] = $email_set->smtp_port;
                                $config['smtp_user'] = $email_set->smtp_username;
                                $config['smtp_pass'] = $email_set->smtp_password;
                                $config['mailtype']  = 'html';
                                $config['charset']   = 'utf-8';
                                $config['newline'] = '\n';
                            }

                            $this->email->initialize($config);
                            $this->email->set_mailtype("html");
                            $this->email->set_newline("\r\n");
                            $this->email->from($email_set->smtp_default_email, $email_set->smtp_display_name);
                            $this->email->to($u_info->user_email);
                            $this->email->subject('New Transaction');
                            $this->email->message($messages);
                            $this->email->send();


                            //* Show success message
                            $this->session->set_flashdata('error', '<div class="alert alert-success" align="center">Success! Thank You For Your Purchase</div>');
                        }
                    }
                    else
                    {
                        $this->session->set_flashdata('error', '<div class="alert alert-warning" align="center">Sorry! Your purchase could not be complete due to fraud payment</div>');
                    }
                }
                else
                {
                    $this->session->set_flashdata('error', '<div class="alert alert-danger" align="center">Error! Your purchase is unsuccessful</div>');
                }
                
                // Redirect to payment status page
                redirect('my-download');;
            }else{
                // Redirect to the home page
                redirect('error_404');
            }
        }
    }

    //* Strip proccess extended liecence
    public function stripe_process_extended()
    {
        $stripe = $this->Payment_model->getStripeGateway();
        $secret_key = $stripe->sg_secret_key;

        $response = array();

        // Check whether stripe token is not empty
        if(!empty($_POST['stripeToken'])){
            
            // Get token, card and item info
            $token  = $_POST['stripeToken'];
            $email  = $_POST['stripeEmail'];
            $itemPrice = $_POST['itemPrice'];
            $currency = $_POST['currency'];
            $itemName = $_POST['itemName'];
            $item_id = $_POST['item_id'];
            
            // Include Stripe PHP library
            // require_once('stripe-php/init.php');
            
            // Set api key
            \Stripe\Stripe::setApiKey($secret_key);
            
            // Add customer to stripe
            $customer = \Stripe\Customer::create(array(
                'email' => $email,
                'source'  => $token
            ));
            
            // Charge a credit or a debit card
            $charge = \Stripe\Charge::create(array(
                'customer' => $customer->id,
                'amount'   => $itemPrice,
                'currency' => $currency,
                'description' => $itemName,
            ));
            
            // Retrieve charge details
            $chargeJson = $charge->jsonSerialize();

            // Check whether the charge is successful
            if($chargeJson['amount_refunded'] == 0 && empty($chargeJson['failure_code']) && $chargeJson['paid'] == 1 && $chargeJson['captured'] == 1){
                
                // Order details 
                $amount = $chargeJson['amount'];
                $currency = $chargeJson['currency'];
                $txnID = $chargeJson['balance_transaction'];
                $status = $chargeJson['status'];
                $orderID = $chargeJson['id'];
                $payerName = $chargeJson['source']['name'];
                
                //* Stroe transaction details
                $data = array(
                    'sp_amount' => $amount,
                    'sp_item_id' => $item_id,
                    'sp_user_id' => $this->session->userdata('uids'),
                    'sp_currency' => $currency,
                    'sp_txn_id' => $txnID,
                    'sp_status' => $status,
                    'sp_order_id' =>$orderID,
                    'sp_payer_name' => $payerName,
                    'sp_payer_email' => $email
                ); 

                if($last_id = $this->Payment_model->createNewStripeTransaction($data))
                {
                    if($last_id && $status == 'succeeded')
                    {
                        $productData = $this->Item_model->getItemPaidFor($item_id);

                        if($is_flash = $this->Item_model->checkIfItemIsFalsh($item_id)) {
                            $item_price_get = $productData->item_exte_price;
                        } else {
                            $item_price_get = $productData->item_exte_price;
                        }

                         //* Site make charges on item
                         $site_info = $this->Settings_model->getApllicationInfo();
                         $site_charge = $site_info->set_item_charge;
 
                         //* Let do charges Calculations
                         $item_price = $item_price_get;
 
                         $cal = ($site_charge / 100) * $item_price;
 
                         $earn = number_format($item_price - $cal, 2); //* What the author will earn
 
                         //* Let creadit the author balance
                         $author_id = $productData->item_user_id;
 
                         //* Catch the author current balance
                         $author_info = $this->Account_model->catchAuthorInfoInPayment($author_id);
 
                         $a_current_bal = $author_info->bal_value; //* Get the authour current balance
 
                         // * Then add to auhor balance
                         $new_a_balance = number_format($a_current_bal + $earn, 2);
 
                         //* Update the author account
                         $this->Account_model->updateAuthorAccountBalance($author_id, $new_a_balance);


                        //* Let us give item to the user
                        if($dl_id = $this->Download_model->createNewDownload($this->session->userdata('uids'), $item_id, 1))
                        {
                            //* Let update the author sell badge stat
                            $this->Account_model->updateAuthorSellBadgeStat($author_id, $item_id, $item_price_get, $dl_id);
                        }

                        $uid = $this->session->userdata('uids');
                        $productID = $item_id;

                        //* Let update sale statement

                        //* Generate purchase code
                        $n = 20;
                        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'; 
                        $randomString = '';
                        for ($i = 0; $i < $n; $i++) { 
                            $index = rand(0, strlen($characters) - 1); 
                            $randomString .= $uid.$productID.$characters[$index]; 
                        }

                        //* Let send to data base
                        $this->Account_model->createNewSaleStatement($uid, $author_id, $earn, $productID, $randomString);


                        //* Let check if purchase are made via refers
                        $site_info = $this->Settings_model->getApllicationInfo();
                        $ref_stat = $site_info->set_affi_status;
                        $ref_rate = $site_info->set_affi_rate;

                        if ($ref_stat == 1) {

                            if ($this->session->userdata('ref')) {
                                //* Let do benefit charges
                                $ref = $this->session->userdata('ref');

                                $ref_cal = ($ref_rate / 100) * $cal;

                                $ref_earn = number_format($ref_cal, 2); //* What the benefical will earn

                                //* Let check if refer exist in our database
                                if ($ref_id = $this->Account_model->checkIfRefExist($ref)) {
                                    //* Let credit his balance
                                    $ref_info = $this->Account_model->catchAuthorInfoInPayment($ref_id);

                                    $a_current_bal = $ref_info->bal_value; //* Get the authour current balance

                                    // * The to auhor balance
                                    $new_a_balance = number_format($a_current_bal + $ref_earn, 2);

                                    //* Update the author account
                                    $this->Account_model->updateAuthorAccountBalance($ref_id, $new_a_balance);
                                }
                            }
                        }

                        /*
                        ==============================================
                        * Let send transaction email to the user
                        ==============================================
                        */

                        //* Get the user informations
                        $u_info = $this->Account_model->getTheUserInfo($this->session->userdata('uids'));

                        //* Let send transactional email to the user
                        $site_info = $this->Settings_model->getApllicationInfo();
                        $template = array(
                            'username' => $u_info->user_username,
                            'email' => $u_info->user_email,
                            'firstname' => $u_info->user_firstname,
                            'lastname' => $u_info->user_lastname,
                            'sitename' => $site_info->set_site_name,
                            'sitelogo' => base_url() . 'static/website/site-logo/' . $site_info->set_site_logo,
                            'main_url' => base_url(),
                            'item_name' => $productData->item_name,
                            'author_user' => $author_info->user_username
                        );
                        
                        $send_u_tnx_email = $this->Email_model->getEmailTempsToSend($id = 3);
                        $template['send_msg'] = $send_u_tnx_email;
                        $messages = $this->parser->parse('mails/welcome/send', $template, true);

                        $email_set = $this->Settings_model->getSmtpDetails();
                        if ($email_set->smtp_type == 'ssl') {
                            $config['protocol']  = 'smtp';
                            $config['smtp_host'] = $email_set->smtp_type . '://' . $email_set->smtp_host;
                            $config['smtp_port'] = $email_set->smtp_port;
                            $config['smtp_user'] = $email_set->smtp_username;
                            $config['smtp_pass'] = $email_set->smtp_password;
                            $config['mailtype']  = 'html';
                            $config['charset']   = 'utf-8';
                            $config['newline'] = '\n';
                        } else {
                            $config['protocol']  = 'smtp';
                            $config['smtp_host'] = $email_set->smtp_host;
                            $config['smtp_port'] = $email_set->smtp_port;
                            $config['smtp_user'] = $email_set->smtp_username;
                            $config['smtp_pass'] = $email_set->smtp_password;
                            $config['mailtype']  = 'html';
                            $config['charset']   = 'utf-8';
                            $config['newline'] = '\n';
                        }

                        $this->email->initialize($config);
                        $this->email->set_mailtype("html");
                        $this->email->set_newline("\r\n");
                        $this->email->from($email_set->smtp_default_email, $email_set->smtp_display_name);
                        $this->email->to($u_info->user_email);
                        $this->email->subject('New Transaction');
                        $this->email->message($messages);
                        $this->email->send();

                        $response = array(
                            'status' => 1,
                            'msg' => 'Your payment was successful.',
                            'txnData' => $chargeJson
                        );
                    }
                    else
                    {
                        $response = array(
                            'status' => 0,
                            'msg' => 'Transaction has been failed.'
                        );
                    }
                }

            }else{
                $response = array(
                    'status' => 0,
                    'msg' => 'Transaction has been failed.'
                );
            }
        }else{
            $response = array(
                'status' => 0,
                'msg' => 'Form submission error...'
            );
        }

        // Return response
        echo json_encode($response);
    }

    //* Buy with credit extended
    public function buy_with_credit_extended()
    {
        if(! $this->session->userdata('uids'))
        {
            redirect('error_404');
            exit();
        }

        if(isset($_POST['item_id']))
        {
            //* Let the user continue to checkout

            $item_id = $this->input->post('item_id');
            $uid = $this->session->userdata('uids');

            //* Let grab the item infomations
            $item_info = $this->Item_model->getItemPayViaBtcPrice($item_id);

            if($is_flash = $this->Item_model->checkIfItemIsFalsh($item_id)) {
                $item_price = $item_info->item_exte_price;
            } else {
                $item_price = $item_info->item_exte_price;
            }

            //* Let grab the user current balance
            $ubal = $this->Account_model->getTheAvaliableUserBalance($uid);
            $cbal = $this->Account_model->getUserAvailbaleCreditBal($uid);

            //* Let detect if Credit balance enough to buy
            if($cbal >= $item_price)
            {
                //* Continue purchasing
                $i_price = $item_price;
                $u_bal = $cbal;

                //* Let charge the user
                $left_bal = $u_bal - $i_price;

                $left_bal = number_format($left_bal, 2);

                //* Let update the user credit balance
                if($this->Account_model->updateUserAltCreditBal($uid, $left_bal))
                {
                    $productData = $this->Item_model->getItemPaidFor($item_id);

                    if($is_flash = $this->Item_model->checkIfItemIsFalsh($item_id)) {
                        $item_price = $this->Item_model->getFlashItemPrice($item_id);
                    } else {
                        //* Let do charges Calculations
                        $item_price = $productData->item_regu_price;
                    }

                    //* Site make charges on item
                    $site_info = $this->Settings_model->getApllicationInfo();
                    $site_charge = $site_info->set_item_charge;


                    $cal = ($site_charge / 100) * $item_price;

                    $earn = number_format($item_price - $cal, 2); //* What the author will earn

                    //* Let creadit the author balance
                    $author_id = $productData->item_user_id;

                    //* Catch the author current balance
                    $author_info = $this->Account_model->catchAuthorInfoInPayment($author_id);

                    $a_current_bal = $author_info->bal_value; //* Get the authour current balance

                    // * Then add to auhor balance
                    $new_a_balance = number_format($a_current_bal + $earn, 2);

                    //* Update the author account
                    $this->Account_model->updateAuthorAccountBalance($author_id, $new_a_balance);


                //* Let us give item to the user
                if($dl_id = $this->Download_model->createNewDownload($this->session->userdata('uids'), $item_id, 1))
                {
                    $this->Account_model->updateAuthorSellBadgeStat($author_id, $item_id, $item_price, $dl_id);
                }

                $uid = $this->session->userdata('uids');
                $productID = $item_id;

                //* Let update sale statement

                //* Generate purchase code
                $n = 20;
                $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'; 
                $randomString = '';
                for ($i = 0; $i < $n; $i++) { 
                    $index = rand(0, strlen($characters) - 1); 
                    $randomString .= $uid.$productID.$characters[$index]; 
                }

                //* Let send to data base
                $this->Account_model->createNewSaleStatement($uid, $author_id, $earn, $productID, $randomString);

                //* Let check if purchase are made via refers
                $site_info = $this->Settings_model->getApllicationInfo();
                $ref_stat = $site_info->set_affi_status;
                $ref_rate = $site_info->set_affi_rate;

                if ($ref_stat == 1) {

                    if ($this->session->userdata('ref')) {
                        //* Let do benefit charges
                        $ref = $this->session->userdata('ref');

                        $ref_cal = ($ref_rate / 100) * $cal;

                        $ref_earn = number_format($ref_cal, 2); //* What the benefical will earn

                        //* Let check if refer exist in our database
                        if ($ref_id = $this->Account_model->checkIfRefExist($ref)) {
                            //* Let credit his balance
                            $ref_info = $this->Account_model->catchAuthorInfoInPayment($ref_id);

                            $a_current_bal = $ref_info->bal_value; //* Get the authour current balance

                            // * The to auhor balance
                            $new_a_balance = number_format($a_current_bal + $ref_earn, 2);

                            //* Update the author account
                            $this->Account_model->updateAuthorAccountBalance($ref_id, $new_a_balance);
                        }
                    }
                }

                /*
                ==============================================
                * Let send transaction email to the user
                ==============================================
                */

                //* Get the user informations
                $u_info = $this->Account_model->getTheUserInfo($this->session->userdata('uids'));

                //* Let send transactional email to the user
                $site_info = $this->Settings_model->getApllicationInfo();
                $template = array(
                    'username' => $u_info->user_username,
                    'email' => $u_info->user_email,
                    'firstname' => $u_info->user_firstname,
                    'lastname' => $u_info->user_lastname,
                    'sitename' => $site_info->set_site_name,
                    'sitelogo' => base_url() . 'static/website/site-logo/' . $site_info->set_site_logo,
                    'main_url' => base_url(),
                    'item_name' => $productData->item_name,
                    'author_user' => $author_info->user_username
                );
                
                $send_u_tnx_email = $this->Email_model->getEmailTempsToSend($id = 3);
                $template['send_msg'] = $send_u_tnx_email;
                $messages = $this->parser->parse('mails/welcome/send', $template, true);

                $email_set = $this->Settings_model->getSmtpDetails();
                if ($email_set->smtp_type == 'ssl') {
                    $config['protocol']  = 'smtp';
                    $config['smtp_host'] = $email_set->smtp_type . '://' . $email_set->smtp_host;
                    $config['smtp_port'] = $email_set->smtp_port;
                    $config['smtp_user'] = $email_set->smtp_username;
                    $config['smtp_pass'] = $email_set->smtp_password;
                    $config['mailtype']  = 'html';
                    $config['charset']   = 'utf-8';
                    $config['newline'] = '\n';
                } else {
                    $config['protocol']  = 'smtp';
                    $config['smtp_host'] = $email_set->smtp_host;
                    $config['smtp_port'] = $email_set->smtp_port;
                    $config['smtp_user'] = $email_set->smtp_username;
                    $config['smtp_pass'] = $email_set->smtp_password;
                    $config['mailtype']  = 'html';
                    $config['charset']   = 'utf-8';
                    $config['newline'] = '\n';
                }

                $this->email->initialize($config);
                $this->email->set_mailtype("html");
                $this->email->set_newline("\r\n");
                $this->email->from($email_set->smtp_default_email, $email_set->smtp_display_name);
                $this->email->to($u_info->user_email);
                $this->email->subject('New Transaction');
                $this->email->message($messages);
                $this->email->send();
                
                $this->session->set_flashdata('error', '<div class="alert alert-success" align="center">Thank you for your purchase</div>');
                redirect('my-download');
                
                }
            }
            elseif($ubal >= $item_price)
            {
                //* Continue purchasing
                $i_price = $item_price;
                $u_bal = $ubal;

                //* Let charge the user
                $left_bal = $u_bal - $i_price;

                $left_bal = number_format($left_bal, 2);

                //* Let update the user credit balance
                if($this->Account_model->updateUserCreditBal($uid, $left_bal))
                {
                    $productData = $this->Item_model->getItemPaidFor($item_id);

                    if($is_flash = $this->Item_model->checkIfItemIsFalsh($item_id)) {
                        $item_price = $this->Item_model->getFlashItemPrice($item_id);
                    } else {
                        //* Let do charges Calculations
                        $item_price = $productData->item_regu_price;
                    }

                    //* Site make charges on item
                    $site_info = $this->Settings_model->getApllicationInfo();
                    $site_charge = $site_info->set_item_charge;


                    $cal = ($site_charge / 100) * $item_price;

                    $earn = number_format($item_price - $cal, 2); //* What the author will earn

                    //* Let creadit the author balance
                    $author_id = $productData->item_user_id;

                    //* Catch the author current balance
                    $author_info = $this->Account_model->catchAuthorInfoInPayment($author_id);

                    $a_current_bal = $author_info->bal_value; //* Get the authour current balance

                    // * Then add to auhor balance
                    $new_a_balance = number_format($a_current_bal + $earn, 2);

                    //* Update the author account
                    $this->Account_model->updateAuthorAccountBalance($author_id, $new_a_balance);


                //* Let us give item to the user
                if($dl_id = $this->Download_model->createNewDownload($this->session->userdata('uids'), $item_id, 1))
                {
                    $this->Account_model->updateAuthorSellBadgeStat($author_id, $item_id, $item_price, $dl_id);
                }

                $uid = $this->session->userdata('uids');
                $productID = $item_id;

                //* Let update sale statement

                //* Generate purchase code
                $n = 20;
                $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'; 
                $randomString = '';
                for ($i = 0; $i < $n; $i++) { 
                    $index = rand(0, strlen($characters) - 1); 
                    $randomString .= $uid.$productID.$characters[$index]; 
                }

                //* Let send to data base
                $this->Account_model->createNewSaleStatement($uid, $author_id, $earn, $productID, $randomString);

                //* Let check if purchase are made via refers
                $site_info = $this->Settings_model->getApllicationInfo();
                $ref_stat = $site_info->set_affi_status;
                $ref_rate = $site_info->set_affi_rate;

                if ($ref_stat == 1) {

                    if ($this->session->userdata('ref')) {
                        //* Let do benefit charges
                        $ref = $this->session->userdata('ref');

                        $ref_cal = ($ref_rate / 100) * $cal;

                        $ref_earn = number_format($ref_cal, 2); //* What the benefical will earn

                        //* Let check if refer exist in our database
                        if ($ref_id = $this->Account_model->checkIfRefExist($ref)) {
                            //* Let credit his balance
                            $ref_info = $this->Account_model->catchAuthorInfoInPayment($ref_id);

                            $a_current_bal = $ref_info->bal_value; //* Get the authour current balance

                            // * The to auhor balance
                            $new_a_balance = number_format($a_current_bal + $ref_earn, 2);

                            //* Update the author account
                            $this->Account_model->updateAuthorAccountBalance($ref_id, $new_a_balance);
                        }
                    }
                }

                /*
                ==============================================
                * Let send transaction email to the user
                ==============================================
                */

                //* Get the user informations
                $u_info = $this->Account_model->getTheUserInfo($this->session->userdata('uids'));

                //* Let send transactional email to the user
                $site_info = $this->Settings_model->getApllicationInfo();
                $template = array(
                    'username' => $u_info->user_username,
                    'email' => $u_info->user_email,
                    'firstname' => $u_info->user_firstname,
                    'lastname' => $u_info->user_lastname,
                    'sitename' => $site_info->set_site_name,
                    'sitelogo' => base_url() . 'static/website/site-logo/' . $site_info->set_site_logo,
                    'main_url' => base_url(),
                    'item_name' => $productData->item_name,
                    'author_user' => $author_info->user_username
                );
                
                $send_u_tnx_email = $this->Email_model->getEmailTempsToSend($id = 3);
                $template['send_msg'] = $send_u_tnx_email;
                $messages = $this->parser->parse('mails/welcome/send', $template, true);

                $email_set = $this->Settings_model->getSmtpDetails();
                if ($email_set->smtp_type == 'ssl') {
                    $config['protocol']  = 'smtp';
                    $config['smtp_host'] = $email_set->smtp_type . '://' . $email_set->smtp_host;
                    $config['smtp_port'] = $email_set->smtp_port;
                    $config['smtp_user'] = $email_set->smtp_username;
                    $config['smtp_pass'] = $email_set->smtp_password;
                    $config['mailtype']  = 'html';
                    $config['charset']   = 'utf-8';
                    $config['newline'] = '\n';
                } else {
                    $config['protocol']  = 'smtp';
                    $config['smtp_host'] = $email_set->smtp_host;
                    $config['smtp_port'] = $email_set->smtp_port;
                    $config['smtp_user'] = $email_set->smtp_username;
                    $config['smtp_pass'] = $email_set->smtp_password;
                    $config['mailtype']  = 'html';
                    $config['charset']   = 'utf-8';
                    $config['newline'] = '\n';
                }

                $this->email->initialize($config);
                $this->email->set_mailtype("html");
                $this->email->set_newline("\r\n");
                $this->email->from($email_set->smtp_default_email, $email_set->smtp_display_name);
                $this->email->to($u_info->user_email);
                $this->email->subject('New Transaction');
                $this->email->message($messages);
                $this->email->send();
                
                $this->session->set_flashdata('error', '<div class="alert alert-success" align="center">Thank you for your purchase</div>');
                redirect('my-download');
                
                }
            }
            elseif($ubal > 1 && $cbal > 1)
            {
                //* Let detect if both balace can be both used

                //* Continue purchasing
                $i_price = $item_price;
                $u_bal = $ubal;
                $c_bal = $cbal;

                //* Get left over after charging alt credit
                $left_over = $i_price - $cbal; //* Get left over balace to charge

                //* Let detect if left user balace can make the purchase
                if($ubal >= $left_over)
                {
                    //* Let update user credit to zero
                    if($this->Account_model->updateUserAltCreditBal($uid, 0))
                    {
                        //* Let charge the user
                        $left_bal = $u_bal - $left_over;

                        $left_bal = number_format($left_bal, 2);

                        //* Let update the user credit balance
                        if($this->Account_model->updateUserCreditBal($uid, $left_bal))
                        {
                            $productData = $this->Item_model->getItemPaidFor($item_id);

                            if($is_flash = $this->Item_model->checkIfItemIsFalsh($item_id)) {
                                $item_price = $this->Item_model->getFlashItemPrice($item_id);
                            } else {
                                //* Let do charges Calculations
                                $item_price = $productData->item_regu_price;
                            }

                            //* Site make charges on item
                            $site_info = $this->Settings_model->getApllicationInfo();
                            $site_charge = $site_info->set_item_charge;


                            $cal = ($site_charge / 100) * $item_price;

                            $earn = number_format($item_price - $cal, 2); //* What the author will earn

                            //* Let creadit the author balance
                            $author_id = $productData->item_user_id;

                            //* Catch the author current balance
                            $author_info = $this->Account_model->catchAuthorInfoInPayment($author_id);

                            $a_current_bal = $author_info->bal_value; //* Get the authour current balance

                            // * Then add to auhor balance
                            $new_a_balance = number_format($a_current_bal + $earn, 2);

                            //* Update the author account
                            $this->Account_model->updateAuthorAccountBalance($author_id, $new_a_balance);


                        //* Let us give item to the user
                        if($dl_id = $this->Download_model->createNewDownload($this->session->userdata('uids'), $item_id, 1))
                        {
                            $this->Account_model->updateAuthorSellBadgeStat($author_id, $item_id, $item_price, $dl_id);
                        }

                        $uid = $this->session->userdata('uids');
                        $productID = $item_id;

                        //* Let update sale statement

                        //* Generate purchase code
                        $n = 20;
                        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'; 
                        $randomString = '';
                        for ($i = 0; $i < $n; $i++) { 
                            $index = rand(0, strlen($characters) - 1); 
                            $randomString .= $uid.$productID.$characters[$index]; 
                        }

                        //* Let send to data base
                        $this->Account_model->createNewSaleStatement($uid, $author_id, $earn, $productID, $randomString);

                        //* Let check if purchase are made via refers
                        $site_info = $this->Settings_model->getApllicationInfo();
                        $ref_stat = $site_info->set_affi_status;
                        $ref_rate = $site_info->set_affi_rate;

                        if ($ref_stat == 1) {

                            if ($this->session->userdata('ref')) {
                                //* Let do benefit charges
                                $ref = $this->session->userdata('ref');

                                $ref_cal = ($ref_rate / 100) * $cal;

                                $ref_earn = number_format($ref_cal, 2); //* What the benefical will earn

                                //* Let check if refer exist in our database
                                if ($ref_id = $this->Account_model->checkIfRefExist($ref)) {
                                    //* Let credit his balance
                                    $ref_info = $this->Account_model->catchAuthorInfoInPayment($ref_id);

                                    $a_current_bal = $ref_info->bal_value; //* Get the authour current balance

                                    // * The to auhor balance
                                    $new_a_balance = number_format($a_current_bal + $ref_earn, 2);

                                    //* Update the author account
                                    $this->Account_model->updateAuthorAccountBalance($ref_id, $new_a_balance);
                                }
                            }
                        }

                        /*
                        ==============================================
                        * Let send transaction email to the user
                        ==============================================
                        */

                        //* Get the user informations
                        $u_info = $this->Account_model->getTheUserInfo($this->session->userdata('uids'));

                        //* Let send transactional email to the user
                        $site_info = $this->Settings_model->getApllicationInfo();
                        $template = array(
                            'username' => $u_info->user_username,
                            'email' => $u_info->user_email,
                            'firstname' => $u_info->user_firstname,
                            'lastname' => $u_info->user_lastname,
                            'sitename' => $site_info->set_site_name,
                            'sitelogo' => base_url() . 'static/website/site-logo/' . $site_info->set_site_logo,
                            'main_url' => base_url(),
                            'item_name' => $productData->item_name,
                            'author_user' => $author_info->user_username
                        );
                        
                        $send_u_tnx_email = $this->Email_model->getEmailTempsToSend($id = 3);
                        $template['send_msg'] = $send_u_tnx_email;
                        $messages = $this->parser->parse('mails/welcome/send', $template, true);

                        $email_set = $this->Settings_model->getSmtpDetails();
                        if ($email_set->smtp_type == 'ssl') {
                            $config['protocol']  = 'smtp';
                            $config['smtp_host'] = $email_set->smtp_type . '://' . $email_set->smtp_host;
                            $config['smtp_port'] = $email_set->smtp_port;
                            $config['smtp_user'] = $email_set->smtp_username;
                            $config['smtp_pass'] = $email_set->smtp_password;
                            $config['mailtype']  = 'html';
                            $config['charset']   = 'utf-8';
                            $config['newline'] = '\n';
                        } else {
                            $config['protocol']  = 'smtp';
                            $config['smtp_host'] = $email_set->smtp_host;
                            $config['smtp_port'] = $email_set->smtp_port;
                            $config['smtp_user'] = $email_set->smtp_username;
                            $config['smtp_pass'] = $email_set->smtp_password;
                            $config['mailtype']  = 'html';
                            $config['charset']   = 'utf-8';
                            $config['newline'] = '\n';
                        }

                        $this->email->initialize($config);
                        $this->email->set_mailtype("html");
                        $this->email->set_newline("\r\n");
                        $this->email->from($email_set->smtp_default_email, $email_set->smtp_display_name);
                        $this->email->to($u_info->user_email);
                        $this->email->subject('New Transaction');
                        $this->email->message($messages);
                        $this->email->send();
                        
                        $this->session->set_flashdata('error', '<div class="alert alert-success" align="center">Thank you for your purchase</div>');
                        redirect('my-download');
                        
                        }
                    }
                }
                else
                {
                    echo "<script> alert('You do not have enough credit to complete purchase');</script>";
                    echo "<script>window.history.back();</script>";
                }

            }
            else
            {
                echo "<script> alert('You do not have enough credit to complete purchase');</script>";
                echo "<script>window.history.back();</script>";
            }
        }
        else
        {
            redirect('error_404');
            exit();
        }
    }

    //* Process btc transaction
    public function prepare_btc_txn()
    {
        if(! $this->input->is_ajax_request())
        {
            redirect('error_404');
            exit();
        }

        $item = $this->input->post('item');
        
        //* Get Bitcoin credential
        $btc_info = $this->Payment_model->getBitcoinGateway();

        //* Let get the item infomations
        $item_info = $this->Item_model->getItemBtcInfo($item);
        $site_info = $this->Settings_model->getApllicationInfo();
        $buyer_info = $this->Account_model->getBuyerInfo($this->session->userdata('uids'));

        //* Intergrate Coinpayment api
        /** Scenario: Create a complex transaction that uses all available fields. **/
        $private_key = $btc_info->btc_private_key;
        $public_key = $btc_info->btc_public_key;

        if($is_flash = $this->Item_model->checkIfItemIsFalsh($item)) {
            $btc_price = $this->Item_model->getFlashItemPrice($item);
        } else {
            $btc_price = $item_info->item_regu_price;
        }

        // Create a new API wrapper instance
        $cps_api = new CoinpaymentsAPI($private_key, $public_key, 'json');

        // Enter amount for the transaction
        // This would be the price for the product or service that you're selling
        $amount = $btc_price + $btc_info->btc_tax;

        // The currency for the amount above (original price)
        $currency1 = strtoupper($site_info->set_site_currency_code);

        // Litecoin Testnet is a no value currency for testing
        // The currency the buyer will be sending equal to amount of $currency1
        $currency2 = 'LTCT';

        // Enter buyer email below
        $buyer_email = $buyer_info->user_email;

        // Set a custom address to send the funds to.
        // Will override the settings on the Coin Acceptance Settings page
        $address = $btc_info->btc_wallet_addr;

        // Enter a buyer name for later reference
        $buyer_name = $buyer_info->user_firstname . ' '.$buyer_info->user_lastname;

        // Enter additional transaction details
        $item_name = $item_info->item_name;
        $item_number = $item_info->item_id;
        $custom = 'Express order';
        $invoice = time().$item_info->item_id;
        $ipn_url = base_url('checkout/btc_regular_ipn');

        // Make call to API to create the transaction
        try {
            $transaction_response = $cps_api->CreateComplexTransaction($amount, $currency1, $currency2, $buyer_email, $address, $buyer_name, $item_name, $item_number, $invoice, $custom, $ipn_url);
        } catch (Exception $e) {
            echo 'Error: ' . $e->getMessage();
            exit();
        }

        // Output the response of the API call
        if ($transaction_response["error"] == "ok") {
            //var_dump($transaction_response);
            $result = $transaction_response;

            //* Prepare txn infomations
            $txn = $result['result']['txn_id'];
            $btc_amount = sprintf('%.08f', $result['result']['amount']);

            //* Let create BTc Transaction
            $data = array(
                'bt_txn' => $txn,
                'bt_item_id' => $item_info->item_id,
                'bt_buyer_id' => $buyer_info->user_id,
                'bt_btc' => $btc_amount
            );

            if($this->Payment_model->createNewBtcTxn($data))
            {
                echo '
                    <script>window.location = "'.$result['result']['checkout_url'].'";</script>
                ';
            }
            else
            {
                echo 'Can not create transactions';
            }
        } else {
            echo $transaction_response["error"];
        }
    }

    //* Process btc transaction extended
    public function prepare_btc_txn_extended()
    {
        
        if(! $this->input->is_ajax_request())
        {
            redirect('error_404');
            exit();
        }

        $item = $this->input->post('item');
        
        //* Get Bitcoin credential
        $btc_info = $this->Payment_model->getBitcoinGateway();

        //* Let get the item infomations
        $item_info = $this->Item_model->getItemBtcInfo($item);
        $site_info = $this->Settings_model->getApllicationInfo();
        $buyer_info = $this->Account_model->getBuyerInfo($this->session->userdata('uids'));

        //* Intergrate Coinpayment api
        /** Scenario: Create a complex transaction that uses all available fields. **/
        $private_key = $btc_info->btc_private_key;
        $public_key = $btc_info->btc_public_key;

        // Create a new API wrapper instance
        $cps_api = new CoinpaymentsAPI($private_key, $public_key, 'json');

        // Enter amount for the transaction
        // This would be the price for the product or service that you're selling
        $amount = $item_info->item_exte_price + $btc_info->btc_tax;

        // The currency for the amount above (original price)
        $currency1 = strtoupper($site_info->set_site_currency_code);

        // Litecoin Testnet is a no value currency for testing
        // The currency the buyer will be sending equal to amount of $currency1
        $currency2 = 'LTCT';

        // Enter buyer email below
        $buyer_email = $buyer_info->user_email;

        // Set a custom address to send the funds to.
        // Will override the settings on the Coin Acceptance Settings page
        $address = $btc_info->btc_wallet_addr;

        // Enter a buyer name for later reference
        $buyer_name = $buyer_info->user_firstname . ' '.$buyer_info->user_lastname;

        // Enter additional transaction details
        $item_name = $item_info->item_name;
        $item_number = $item_info->item_id;
        $custom = 'Express order';
        $invoice = time().$item_info->item_id;
        $ipn_url = base_url('btc_extended_ipn');

        // Make call to API to create the transaction
        try {
            $transaction_response = $cps_api->CreateComplexTransaction($amount, $currency1, $currency2, $buyer_email, $address, $buyer_name, $item_name, $item_number, $invoice, $custom, $ipn_url);
        } catch (Exception $e) {
            echo 'Error: ' . $e->getMessage();
            exit();
        }

        // Output the response of the API call
        if ($transaction_response["error"] == "ok") {
            //var_dump($transaction_response);
            $result = $transaction_response;

            //* Prepare txn infomations
            $txn = $result['result']['txn_id'];
            $btc_amount = sprintf('%.08f', $result['result']['amount']);

            //* Let create BTc Transaction
            $data = array(
                'bt_txn' => $txn,
                'bt_item_id' => $item_info->item_id,
                'bt_buyer_id' => $buyer_info->user_id,
                'bt_btc' => $btc_amount
            );

            if($this->Payment_model->createNewBtcTxn($data))
            {
                echo '
                    <script>window.location = "'.$result['result']['checkout_url'].'";</script>
                ';
            }
            else
            {
                echo 'Can not create transactions';
            }
        } else {
            echo $transaction_response["error"];
        }
    }

    //* Bitcoin ipn for regular liecence
    public function btc_regular_ipn()
    {
        //* get bitcoin settings infomations
        $btc_info = $this->Payment_model->getBitcoinGateway();
        $site_info = $this->Settings_model->getApllicationInfo();

         // Fill these in with the information from your CoinPayments.net account.
        $cp_merchant_id = $btc_info->btc_machant_id;
        $cp_ipn_secret = $btc_info->btc_ipn_secret;
        $cp_debug_email = $site_info->set_email;

        //These would normally be loaded from your database, the most common way is to pass the Order ID through the 'custom' POST field.

        function errorAndDie($error_msg) {
            global $cp_debug_email;
            if (!empty($cp_debug_email)) {
                $report = 'Error: '.$error_msg."\n\n";
                $report .= "POST Data\n\n";
                foreach ($_POST as $k => $v) {
                    $report .= "|$k| = |$v|\n";
                }
                mail($cp_debug_email, 'CoinPayments IPN Error', $report);
            }
            die('IPN Error: '.$error_msg);
        }

        if (!isset($_POST['ipn_mode']) || $_POST['ipn_mode'] != 'hmac') {
            errorAndDie('IPN Mode is not HMAC');
        }

        if (!isset($_SERVER['HTTP_HMAC']) || empty($_SERVER['HTTP_HMAC'])) {
            errorAndDie('No HMAC signature sent.');
        }

        $request = file_get_contents('php://input');
        if ($request === FALSE || empty($request)) {
            errorAndDie('Error reading POST data');
        }

        if (!isset($_POST['merchant']) || $_POST['merchant'] != trim($cp_merchant_id)) {
            errorAndDie('No or incorrect Merchant ID passed');
        }

        $hmac = hash_hmac("sha512", $request, trim($cp_ipn_secret));
        if (!hash_equals($hmac, $_SERVER['HTTP_HMAC'])) {
        //if ($hmac != $_SERVER['HTTP_HMAC']) { <-- Use this if you are running a version of PHP below 5.6.0 without the hash_equals function
            errorAndDie('HMAC signature does not match');
        }

        // HMAC Signature verified at this point, load some variables.

        $ipn_type = $_POST['ipn_type'];
        $txn_id = $_POST['txn_id'];
        $status = intval($_POST['status']);
        $status_text = $_POST['status_text'];

        if ($status >= 100 || $status == 2) {
            //* Let update the transaction status
            if($this->Payment_model->updateBtcTxnStatus($txn_id))
            {
                //* Process the iem for buyer and author
                $productID = $this->Payment_model->getItemPaidFor($txn_id);
                $productData = $this->Item_model->getItemPaidFor($productID);

                if($is_flash = $this->Item_model->checkIfItemIsFalsh($productID)) {
                    $item_price_get = $this->Item_model->getFlashItemPrice($productID);
                } else {
                    $item_price_get = $productData->item_regu_price;
                }
                
                // If payment price is valid

                //* Site make charges on item
                $site_info = $this->Settings_model->getApllicationInfo();
                $site_charge = $site_info->set_item_charge;

                //* Let do charges Calculations
                $item_price = $item_price_get;

                $cal = ($site_charge / 100) * $item_price;

                $earn = number_format($item_price - $cal, 2); //* What the author will earn

                //* Let creadit the author balance
                $author_id = $productData->item_user_id;

                //* Catch the author current balance
                $author_info = $this->Account_model->catchAuthorInfoInPayment($author_id);

                $a_current_bal = $author_info->bal_value; //* Get the authour current balance

                // * The to auhor balance
                $new_a_balance = number_format($a_current_bal + $earn, 2);

                //* Update the author account
                $this->Account_model->updateAuthorAccountBalance($author_id, $new_a_balance);

                //* Let check if purchase are made via refers
                $site_info = $this->Settings_model->getApllicationInfo();
                $ref_stat = $site_info->set_affi_status;
                $ref_rate = $site_info->set_affi_rate;

                //* Give item to user here
                $uid = $this->Payment_model->getBuyerId($txn_id);

                if($dl_id = $this->Download_model->createNewDownload($uid, $productID))
                {

                    //* Let update the author sell badge stat
                    $this->Account_model->updateAuthorSellBadgeStat($author_id, $productID, $item_price_get, $dl_id);

                    //* Let update sale statement

                    //* Generate purchase code
                    $n = 20;
                    $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'; 
                    $randomString = '';
                    for ($i = 0; $i < $n; $i++) { 
                        $index = rand(0, strlen($characters) - 1); 
                        $randomString .= $uid.$productID.$characters[$index]; 
                    }

                    //* Let send to data base
                    $this->Account_model->createNewSaleStatement($uid, $author_id, $earn, $productID, $randomString);

                    /*
                    ==============================================
                    * Let send transaction email to the user
                    ==============================================
                    */

                    //* Get the user informations
                    $u_info = $this->Account_model->getTheUserInfo($uid);

                    //* Let send transactional email to the user
                    $site_info = $this->Settings_model->getApllicationInfo();
                    $template = array(
                        'username' => $u_info->user_username,
                        'email' => $u_info->user_email,
                        'firstname' => $u_info->user_firstname,
                        'lastname' => $u_info->user_lastname,
                        'sitename' => $site_info->set_site_name,
                        'sitelogo' => base_url() . 'static/website/site-logo/' . $site_info->set_site_logo,
                        'main_url' => base_url(),
                        'item_name' => $productData->item_name,
                        'author_user' => $author_info->user_username
                    );
                    
                    $send_u_tnx_email = $this->Email_model->getEmailTempsToSend($id = 3);
                    $template['send_msg'] = $send_u_tnx_email;
                    $messages = $this->parser->parse('mails/welcome/send', $template, true);

                    $email_set = $this->Settings_model->getSmtpDetails();
                    if ($email_set->smtp_type == 'ssl') {
                        $config['protocol']  = 'smtp';
                        $config['smtp_host'] = $email_set->smtp_type . '://' . $email_set->smtp_host;
                        $config['smtp_port'] = $email_set->smtp_port;
                        $config['smtp_user'] = $email_set->smtp_username;
                        $config['smtp_pass'] = $email_set->smtp_password;
                        $config['mailtype']  = 'html';
                        $config['charset']   = 'utf-8';
                        $config['newline'] = '\n';
                    } else {
                        $config['protocol']  = 'smtp';
                        $config['smtp_host'] = $email_set->smtp_host;
                        $config['smtp_port'] = $email_set->smtp_port;
                        $config['smtp_user'] = $email_set->smtp_username;
                        $config['smtp_pass'] = $email_set->smtp_password;
                        $config['mailtype']  = 'html';
                        $config['charset']   = 'utf-8';
                        $config['newline'] = '\n';
                    }

                    $this->email->initialize($config);
                    $this->email->set_mailtype("html");
                    $this->email->set_newline("\r\n");
                    $this->email->from($email_set->smtp_default_email, $email_set->smtp_display_name);
                    $this->email->to($u_info->user_email);
                    $this->email->subject('New Transaction');
                    $this->email->message($messages);
                    $this->email->send();
                }
            }
        } else if ($status < 0) {
            //payment error, this is usually final but payments will sometimes be reopened if there was no exchange rate conversion or with seller consent
            $fp = fopen('data.txt', 'w');
            fwrite($fp, 'IPN was call');
            fwrite($fp, ' with on hold stat');
            fclose($fp);
        } else {
            //payment is pending, you can optionally add a note to the order page
        }
        die('IPN OK');
    }

    //* Bitcoin ipn for extended liecece
    public function btc_extended_ipn()
    {
        //* get bitcoin settings infomations
        $btc_info = $this->Payment_model->getBitcoinGateway();
        $site_info = $this->Settings_model->getApllicationInfo();

         // Fill these in with the information from your CoinPayments.net account.
        $cp_merchant_id = $btc_info->btc_machant_id;
        $cp_ipn_secret = $btc_info->btc_ipn_secret;
        $cp_debug_email = $site_info->set_email;

        //These would normally be loaded from your database, the most common way is to pass the Order ID through the 'custom' POST field.

        function errorAndDie($error_msg) {
            global $cp_debug_email;
            if (!empty($cp_debug_email)) {
                $report = 'Error: '.$error_msg."\n\n";
                $report .= "POST Data\n\n";
                foreach ($_POST as $k => $v) {
                    $report .= "|$k| = |$v|\n";
                }
                mail($cp_debug_email, 'CoinPayments IPN Error', $report);
            }
            die('IPN Error: '.$error_msg);
        }

        if (!isset($_POST['ipn_mode']) || $_POST['ipn_mode'] != 'hmac') {
            errorAndDie('IPN Mode is not HMAC');
        }

        if (!isset($_SERVER['HTTP_HMAC']) || empty($_SERVER['HTTP_HMAC'])) {
            errorAndDie('No HMAC signature sent.');
        }

        $request = file_get_contents('php://input');
        if ($request === FALSE || empty($request)) {
            errorAndDie('Error reading POST data');
        }

        if (!isset($_POST['merchant']) || $_POST['merchant'] != trim($cp_merchant_id)) {
            errorAndDie('No or incorrect Merchant ID passed');
        }

        $hmac = hash_hmac("sha512", $request, trim($cp_ipn_secret));
        if (!hash_equals($hmac, $_SERVER['HTTP_HMAC'])) {
        //if ($hmac != $_SERVER['HTTP_HMAC']) { <-- Use this if you are running a version of PHP below 5.6.0 without the hash_equals function
            errorAndDie('HMAC signature does not match');
        }

        // HMAC Signature verified at this point, load some variables.

        $ipn_type = $_POST['ipn_type'];
        $txn_id = $_POST['txn_id'];
        $status = intval($_POST['status']);
        $status_text = $_POST['status_text'];

        if ($status >= 100 || $status == 2) {
            //* Let update the transaction status
            if($this->Payment_model->updateBtcTxnStatus($txn_id))
            {
                //* Process the iem for buyer and author
                $productID = $this->Payment_model->getItemPaidFor($txn_id);
                $productData = $this->Item_model->getItemPaidFor($productID);

                $item_price_get = $productData->item_exte_price;
                
                // If payment price is valid

                //* Site make charges on item
                $site_info = $this->Settings_model->getApllicationInfo();
                $site_charge = $site_info->set_item_charge;

                //* Let do charges Calculations
                $item_price = $item_price_get;

                $cal = ($site_charge / 100) * $item_price;

                $earn = number_format($item_price - $cal, 2); //* What the author will earn

                //* Let creadit the author balance
                $author_id = $productData->item_user_id;

                //* Catch the author current balance
                $author_info = $this->Account_model->catchAuthorInfoInPayment($author_id);

                $a_current_bal = $author_info->bal_value; //* Get the authour current balance

                // * The to auhor balance
                $new_a_balance = number_format($a_current_bal + $earn, 2);

                //* Update the author account
                $this->Account_model->updateAuthorAccountBalance($author_id, $new_a_balance);

                //* Let check if purchase are made via refers
                $site_info = $this->Settings_model->getApllicationInfo();
                $ref_stat = $site_info->set_affi_status;
                $ref_rate = $site_info->set_affi_rate;

                //* Give item to user here
                $uid = $this->Payment_model->getBuyerId($txn_id);

                if($dl_id = $this->Download_model->createNewDownload($uid, $productID, 1))
                {

                    //* Let update the author sell badge stat
                    $this->Account_model->updateAuthorSellBadgeStat($author_id, $productID, $item_price_get, $dl_id);

                    //* Let update sale statement

                    //* Generate purchase code
                    $n = 20;
                    $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'; 
                    $randomString = '';
                    for ($i = 0; $i < $n; $i++) { 
                        $index = rand(0, strlen($characters) - 1); 
                        $randomString .= $uid.$productID.$characters[$index]; 
                    }

                    //* Let send to data base
                    $this->Account_model->createNewSaleStatement($uid, $author_id, $earn, $productID, $randomString);

                    /*
                    ==============================================
                    * Let send transaction email to the user
                    ==============================================
                    */

                    //* Get the user informations
                    $u_info = $this->Account_model->getTheUserInfo($uid);

                    //* Let send transactional email to the user
                    $site_info = $this->Settings_model->getApllicationInfo();
                    $template = array(
                        'username' => $u_info->user_username,
                        'email' => $u_info->user_email,
                        'firstname' => $u_info->user_firstname,
                        'lastname' => $u_info->user_lastname,
                        'sitename' => $site_info->set_site_name,
                        'sitelogo' => base_url() . 'static/website/site-logo/' . $site_info->set_site_logo,
                        'main_url' => base_url(),
                        'item_name' => $productData->item_name,
                        'author_user' => $author_info->user_username
                    );
                    
                    $send_u_tnx_email = $this->Email_model->getEmailTempsToSend($id = 3);
                    $template['send_msg'] = $send_u_tnx_email;
                    $messages = $this->parser->parse('mails/welcome/send', $template, true);

                    $email_set = $this->Settings_model->getSmtpDetails();
                    if ($email_set->smtp_type == 'ssl') {
                        $config['protocol']  = 'smtp';
                        $config['smtp_host'] = $email_set->smtp_type . '://' . $email_set->smtp_host;
                        $config['smtp_port'] = $email_set->smtp_port;
                        $config['smtp_user'] = $email_set->smtp_username;
                        $config['smtp_pass'] = $email_set->smtp_password;
                        $config['mailtype']  = 'html';
                        $config['charset']   = 'utf-8';
                        $config['newline'] = '\n';
                    } else {
                        $config['protocol']  = 'smtp';
                        $config['smtp_host'] = $email_set->smtp_host;
                        $config['smtp_port'] = $email_set->smtp_port;
                        $config['smtp_user'] = $email_set->smtp_username;
                        $config['smtp_pass'] = $email_set->smtp_password;
                        $config['mailtype']  = 'html';
                        $config['charset']   = 'utf-8';
                        $config['newline'] = '\n';
                    }

                    $this->email->initialize($config);
                    $this->email->set_mailtype("html");
                    $this->email->set_newline("\r\n");
                    $this->email->from($email_set->smtp_default_email, $email_set->smtp_display_name);
                    $this->email->to($u_info->user_email);
                    $this->email->subject('New Transaction');
                    $this->email->message($messages);
                    $this->email->send();
                }
            }
        } else if ($status < 0) {
            //payment error, this is usually final but payments will sometimes be reopened if there was no exchange rate conversion or with seller consent
            $fp = fopen('data.txt', 'w');
            fwrite($fp, 'IPN was call');
            fwrite($fp, ' with on hold stat');
            fclose($fp);
        } else {
            //payment is pending, you can optionally add a note to the order page
        }
        die('IPN OK');
    }

    


}

